#include "E:\@Dokumenty\pic\vysilac\main.h"

#DEFINE LCD_RS          PIN_B1      // rizeni registru LCD displeje
#DEFINE LCD_E           PIN_B2      // enable LCD displeje
#DEFINE LCD_DATA_LSB    PIN_B4      // pripojeni LSB bitu datoveho portu LCD displeje (celkem 4 bity vzestupne za sebou)
#INCLUDE "MYLCD.C"

#DEFINE  VYSILAC        PIN_C3
#DEFINE  OSA_X          0           // adresa A/D prevodniku pro osu X
#DEFINE  OSA_Y          1           // adresa A/D prevodniku pro osu Y
#DEFINE  IMPULS         250         // sirka impulsu pro false |-|
#DEFINE  TTL1           PIN_b4
#DEFINE  TTL2           PIN_b3

int stredX, stredY, x, y;


void odeslat (int8 kodeslani)
{
   int i;

   for  (i=0;i<=7;i++)
   {
     if (1==bit_test(kodeslani,i))
     {
        output_high(VYSILAC);
        delay_us(2*IMPULS);          // X pri 1: |--|___
        output_low(VYSILAC);
        delay_us(3*IMPULS);
     }
     else
     {
         output_high(VYSILAC);
         delay_us(IMPULS);           // X pri 0: |-|__|-|_
         output_low(VYSILAC);

         delay_us(2*IMPULS);

         output_high(VYSILAC);
         delay_us(IMPULS);
         output_low(VYSILAC);
         delay_us(IMPULS);
     };
   }
}

void synchronizace()
{
int8 sinchro;
   sinchro=0b00001111;

   odeslat (sinchro);                  // synchronizace: |--|___|--|___|--|___|--|___|-|__|-|_|-|__|-|_|-|__|-|_|-|__|-|_
}



void odesli (int8 X, int8 Y)
{
  odeslat(X+ (X << 4));
  odeslat(Y+ (Y << 4));

}


void kalibrace()
{
int8 min_x;
int8 max_x;
int8 min_y;
int8 max_y;
int8 sred_x;
int8 sred_y;
int8 adc;
   min_x=max_x=min_y=max_y=sred_x=sred_y=128;

   printf(lcd_putc,"Paku dejte do prostred a stisknete tlacitko");
znovu:   
   if (TTL1 || TTL2)
   {
   set_adc_channel(OSA_X);
   delay_us(10);
   sred_x=read_adc();
   set_adc_channel(OSA_y);
   delay_us(10);
   sred_y=read_adc();
   };
   
   //else goto znovu;
   
   printf(lcd_putc,"\f");
   printf(lcd_putc,"Pak ");
   
   set_adc_channel(OSA_X);
   delay_us(10);
   
   adc=read_adc();
   
   if (max_x < adc )max_x=adc;
   if (min_x > adc )min_x=adc;
   
   set_adc_channel(OSA_y);
   delay_us(10);
   
   adc=read_adc();
   
   if (max_y < adc )max_y=adc;
   if (min_y > adc )min_y=adc;
   
   if (TTL1 || TTL2) return;
}


void main()
{
int c=0;

   setup_adc_ports(RA0_RA1_RA3_ANALOG);
   setup_adc(ADC_CLOCK_DIV_2);
   setup_spi(FALSE);
   setup_counters(RTCC_INTERNAL,RTCC_DIV_2);
   setup_timer_1(T1_DISABLED);
   setup_timer_2(T2_DISABLED,0,1);

   lcd_init();

 /*  while (c<=16)
   {
   lcd_gotoxy(c,1);
   printf(lcd_putc,"_");
   delay_ms(50);
   printf(lcd_putc,"\f");
   c++;
   }
   
   printf(lcd_putc,"\fAhoj!");
   delay_ms(1500);*/
   
   printf(lcd_putc,"\f");


   while(true)
   {
      set_adc_channel(OSA_X);
      lcd_gotoxy(1,1);
      x=read_adc() >> 4;
      printf(lcd_putc,"X: %D      ", x);
      set_adc_channel(OSA_Y);
      lcd_gotoxy(1,2);
      y=read_adc() >> 4;
      printf(lcd_putc,"Y: %D      ", y);





 /*     output_high(PIN_C1);
      output_low(PIN_C2);
      delay_ms(100);
      output_low(PIN_C1);
      output_high(PIN_C2);
      delay_ms(100);*/

      lcd_gotoxy(7,2);
      printf(lcd_putc,"vysilam");

      output_high(PIN_C4);
      output_high(PIN_C6);
      delay_ms(1);
      output_low(PIN_C4);
      synchronizace();
      odesli(x,y);
      output_low(PIN_C6);


   }

}
